/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.features.IPlayerRegistry;
import appeng.api.networking.IGrid;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.blockentity.misc.SecurityStationBlockEntity;
import appeng.core.definitions.AEItems;
import appeng.core.localization.GuiText;
import appeng.items.tools.BiometricCardItem;
import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;

public class SecurityStationInventory
implements MEStorage {
    private final Set<AEItemKey> storedItems = new HashSet<AEItemKey>();
    private final SecurityStationBlockEntity blockEntity;

    public SecurityStationInventory(SecurityStationBlockEntity ts) {
        this.blockEntity = ts;
    }

    @Override
    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        AEItemKey itemKey;
        if (this.hasPermission(source) && what instanceof AEItemKey && AEItems.BIOMETRIC_CARD.isSameAs(itemKey = (AEItemKey)what) && this.canAccept(itemKey) && amount > 0L) {
            if (mode == Actionable.MODULATE) {
                this.storedItems.add(itemKey);
                this.blockEntity.inventoryChanged();
            }
            return 1L;
        }
        return 0L;
    }

    private boolean hasPermission(IActionSource src) {
        IGrid grid;
        if (src.player().isPresent() && (grid = this.blockEntity.getMainNode().getGrid()) != null) {
            return grid.getSecurityService().hasPermission(src.player().get(), SecurityPermissions.SECURITY);
        }
        return false;
    }

    @Override
    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (this.hasPermission(source) && amount > 0L && what instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)what;
            if (mode == Actionable.SIMULATE && this.storedItems.contains(itemKey)) {
                return 1L;
            }
            if (this.storedItems.remove(itemKey)) {
                this.blockEntity.inventoryChanged();
                return 1L;
            }
        }
        return 0L;
    }

    @Override
    public void getAvailableStacks(KeyCounter out) {
        for (AEItemKey storedItem : this.storedItems) {
            out.add(storedItem, 1L);
        }
    }

    public boolean canAccept(AEItemKey what) {
        if (this.storedItems.contains(what)) {
            return false;
        }
        Item item = what.getItem();
        if (item instanceof BiometricCardItem) {
            BiometricCardItem biometricCard = (BiometricCardItem)item;
            GameProfile newUser = biometricCard.getProfile(what);
            IPlayerRegistry pr = IPlayerRegistry.getMapping(this.blockEntity.m_58904_());
            if (pr == null) {
                return true;
            }
            if (newUser != null) {
                int playerId = pr.getPlayerId(newUser);
                if (this.blockEntity.getOwner() == playerId) {
                    return false;
                }
            }
            for (AEItemKey entry : this.storedItems) {
                GameProfile existingUser = biometricCard.getProfile(entry);
                if (existingUser == newUser) {
                    return false;
                }
                if (existingUser == null || !existingUser.equals((Object)newUser)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Collection<AEItemKey> getStoredItems() {
        return this.storedItems;
    }

    @Override
    public Component getDescription() {
        return GuiText.Security.text();
    }
}

